Shell={};
Shell.driveroot=GlobalOptions.driveroot
Shell.trace=target.trace;
Shell.log=new Logger("Shell");
//a not very robust copying function. groks a:/ and b:/
Shell.copyFile = function(from,to)
{
	var log=this.log.enter("copyFile");
	try {
		FileSystem.copyFile(from, to);
		if (FileSystem.getFileInfo(to)){
			log.leave("OK");
			return true;
		}
	}catch(e) {log.error(e)};
	log.leave("ERROR: copy FAILED");
	return false;
}

//load an VM from xml. mainly intended to load extenstions
Shell.loadVm = function(path)
{
	var log=this.log.enter("loadVm",path);
	try {
		var myvm = FskInclude.load(path);
//    this.trace("myvm = "+myvm);
		if (!myvm) return 0;
//    this.trace(myvm.serialize());
//      this.trace("before load()\n");
		var t = myvm.load();
		log.log("load result: ",t);
		log.leave();
	}catch(e){ log.error(e);}
}

//return file's content in a string
Shell.fileToString = function(path)
{
	var log=this.log.enter("fileToString");
	var res="";
	try {
		var f = new Stream.File(path)
		res = f.toString();
		log.leave(res)
		return res;
	}catch(e){ log.error(e);}
	return null;
}

//write string to file, overwriting if needed
Shell.stringToFile = function(path, text)
{
	var log=this.log.enter("stringToFile");
	try {
		if (FileSystem.getFileInfo(path))
			FileSystem.deleteFile(path);
		var stream = new Stream.File(path, 1);
		stream.writeString(text);
		stream.close();
		log.leave();
	}catch(e){ log.error(e);}
}

/*
Shell.reboot=function(value) {
	if (!value) return 0;
	ebook.setExitCode(3);
	this.container.getWindow().doQuit();
}
*/


Shell.scriptPrepared = false;
Shell.prepareScript = function(){
	var log = this.log.enter("prepareScript");
	if (!this.scriptPrepared){
		if (!this.copyFile(this.driveroot+"/libfskLoad.so","/tmp/libfskLoad.so")){
			this.log.log("Copy error");
			return 0;
		}
//    this.stringToFile("/tmp/cardroot", this.driveroot);
		this.scriptPrepared = true;
	}
	return this.scriptPrepared;
}

//run /tmp/script.sh
Shell.runScript = function(){
	var log = this.log.enter("runScript");
	try {
		if (this.prepareScript()){
			this.loadVm(this.driveroot+"/myvm2.xml");
			log.leave("loaded");
		} else log.leave("Script not prepared");
	}catch(e){ log.error(e);}
}

//put text into /tmp/script.sh and run it
Shell.runCommand = function(text){
	var log = this.log.enter("runCommand",text);
	try {
		var header = "#!/bin/sh\n"+
		"PATH=\"/usr/local/bin:/usr/bin:/sbin:/bin:/usr/bin/X11:/usr/games:/usr/local/sony/bin:/usr/sbin\"\n"+
		"LD_LIBRARY_PATH=\"/opt/sony/ebook/application:/lib:/usr/lib:/usr/local/sony/lib:/opt/sony/ebook/lib\"\n"
		"export PATH LD_LIBRARY_PATH\n";
		this.stringToFile("/tmp/script.sh", header+text);
		this.runScript();
		log.leave();
	}catch(e){ log.error(e);}
}

//run a command and return the result
Shell.runCommandResult = function(text){
	var tmpf = "/tmp/__result__";
	var log = this.log.enter("runCommandResult");
	try {
		this.runCommand(text+"\necho -n $? >"+tmpf);
		var res = this.fileToString(tmpf);
		FileSystem.deleteFile(tmpf);
		log.leave("Result: "+res);
	}catch(e){ log.error(e);}
	return res;
}

//run command and check if it succeeded (returned 0)
Shell.runCommandCheck = function(text){
	var log = this.log.enter("runCommandCheck");
	var r = this.runCommandResult(text);
//this.trace("command: "+text+"\nresult: "+r);
	return (r.toString()=="0");
}

